/*************************************************************************
 *
 * Hitchhiker's Guide to the IBM PE 
 * Series Evaluation - serial version
 * Chapter 2 - The Answer is 42
 *
 * To compile:
 * cc -o series_serial series_serial.c -lm
 *
 *************************************************************************/

#include<stdlib.h>
#include<stdio.h>
#include<math.h>

double angle[] = { 0.0, 0.1*M_PI, 0.2*M_PI, 0.3*M_PI, 0.4*M_PI, 
	      0.5*M_PI, 0.6*M_PI, 0.7*M_PI, 0.8*M_PI, 0.9*M_PI, M_PI }; 

#define TERMS 8

int main(int argc, char **argv)
{
  double divisor[TERMS], sine;
  int a, t, angles = sizeof(angle)/sizeof(angle[0]);

  /* Initialize denominators of series terms */
  divisor[0] = 1;
  for(t=1;t<TERMS;t++)
    {
      divisor[t] = -2*t*(2*t+1)*divisor[t-1];
    }

  /* Compute sine of each angle */
  for(a=0;a<angles;a++)
    {
      sine = 0;
      /* Sum the terms of the series */
      for(t=0;t<TERMS;t++)
	{
	  sine += pow(angle[a],(2*t+1))/divisor[t];
	}
      printf("sin(%lf) + %lf\n",angle[a],sine);
    }
}
